//
//  ViewController.swift
//  Swift_UiCollectionVIew_images


import UIKit

class ViewController: UIViewController, UICollectionViewDataSource, UICollectionViewDelegate {

    @IBOutlet var collectionview: UICollectionView!
    
    var images_cache = [String:UIImage]()
    var images = [String]()
    let link = "http://www.kaleidosblog.com/tutorial/get_images.php"
    
    override func viewDidLoad() {
        super.viewDidLoad()

        
        let layout:UICollectionViewFlowLayout = UICollectionViewFlowLayout()

        layout.itemSize = CGSize(width: 120,height: 120)
        
        
        self.collectionview.setCollectionViewLayout(layout, animated: true)
        
        get_json()
        
        collectionview.delegate = self
        collectionview.dataSource = self
    }

    
    
    internal func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int
    {
        return images.count
    }
    

    internal func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell
    {
        let cell:CellClass = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! CellClass
        
        if (images_cache[images[indexPath.row]] != nil)
        {
            cell.Image.image = images_cache[images[indexPath.row]]
        }
        else
        {
            load_image(images[indexPath.row], imageview:cell.Image)
        }
        
        return cell
    }
    

    internal func numberOfSections(in collectionView: UICollectionView) -> Int
    {
        return 1
    }
    
    
    
    
    
    func load_image(_ link:String, imageview:UIImageView)
    {
        
        let url:URL = URL(string: link)!
        let session = URLSession.shared
        
        let request = NSMutableURLRequest(url: url)
        request.timeoutInterval = 10

        
        let task = session.dataTask(with: request as URLRequest, completionHandler: {
            (
            data, response, error) in
            
            guard let _:Data = data, let _:URLResponse = response, error == nil else {
                
                return
            }
                
 
            var image = UIImage(data: data!)
            
            if (image != nil)
            {
                
                
                func set_image()
                {
                    self.images_cache[link] = image
                    imageview.image = image
                }
  
                
                DispatchQueue.main.async(execute: set_image)
                
            }
            
        }) 
        
        task.resume()
        
    }

    


    func extract_json_data(_ data:Data)
    {
        let json: Any?
        
        do
        {
            json = try JSONSerialization.jsonObject(with: data, options: [])
            
        }
        catch
        {
            print("error")
            return
        }
        
        guard let images_array = json! as? NSArray else
        {
            print("error")
            return
        }
        
        for j in 0 ..< images_array.count
        {
            images.append(images_array[j] as! String)
        }
        
        DispatchQueue.main.async(execute: refresh)
    }
    
    
    
    func refresh()
    {
        self.collectionview.reloadData()
    }
    

    func get_json()
    {
     
        let url:URL = URL(string: link)!
        let session = URLSession.shared
        
        let request = NSMutableURLRequest(url: url)
        request.timeoutInterval = 10
        
        
        let task = session.dataTask(with: request as URLRequest, completionHandler: {
            (
            data, response, error) in
            
            guard let _:Data = data, let _:URLResponse = response, error == nil else {
                
                return
            }
           

            self.extract_json_data(data!)
            
        }) 
        
        task.resume()
        
    }
    

    

}

