//
//  ViewController.swift
//  custom_uitablewview
//


import UIKit

class ViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {

    @IBOutlet var tableview: UITableView!
    
    var table_data = Array<TableData>()
    
 
    struct TableData
    {
        var section:String = ""
        var data = Array<String>()
        
        init(){}
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableview.dataSource = self
        tableview.delegate = self
        
        var new_elements:TableData
        
        new_elements = TableData()
        new_elements.section = "Section 1"
        new_elements.data.append("Element 1")
        new_elements.data.append("Element 2")
        new_elements.data.append("Element 3")
        new_elements.data.append("Element 4")
        new_elements.data.append("Element 5")
        new_elements.data.append("Element 6")
        new_elements.data.append("Element 7")
        
        
        table_data.append(new_elements)


        new_elements = TableData()
        new_elements.section = "Section 2"
        new_elements.data.append("Element 1")
        new_elements.data.append("Element 2")

        table_data.append(new_elements)
        
        new_elements = TableData()
        new_elements.section = "Section 3"
        new_elements.data.append("Element 1")
        new_elements.data.append("Element 2")
        new_elements.data.append("Element 3")
        new_elements.data.append("Element 4")
        new_elements.data.append("Element 5")
        new_elements.data.append("Element 6")
        new_elements.data.append("Element 7")
        
        table_data.append(new_elements)

    }

    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell
    {
        let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as CustomCell
        
        cell.name.text = table_data[indexPath.section].data[indexPath.row]
        cell.index.text = String(indexPath.row)
        
        return cell

    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int
    {
        return table_data[section].data.count
    }
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int
    {
        return table_data.count
    }
    
    func tableView(tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let  headerCell = tableView.dequeueReusableCellWithIdentifier("customheader") as CustomHeader
       
        headerCell.section_title.text = table_data[section].section
        headerCell.backgroundColor =  UIColor(red:72/255,green:141/255,blue:200/255,alpha:0.9)
        
        return headerCell
        
    }
    
    func tableView(tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 70.0
    }
    
    func sectionIndexTitlesForTableView(tableView: UITableView) -> [AnyObject]!
    {
        
        let sections_names = table_data.map { $0.section  }
        return sections_names

    }
    
    func tableView(tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let footerView = UIView(frame: CGRectMake(0, 0, tableView.frame.size.width, 40))
        footerView.backgroundColor =  UIColor.whiteColor()
        return footerView
    }
    
    func tableView(tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 100.0
    }
    


}

