//
//  ViewController.swift
//  json_parsing_extraction
//


import UIKit

class ViewController: UIViewController {

    
    var colors:[Color] = [Color]()
    
    struct Color
    {
        var name:String = ""
        var hex:String = ""
        
        init(data:NSDictionary)
        {
            
            if let add = data["colorName"] as? String
            {
                self.name = add
            }
            
            if let add = data["hexValue"] as? String
            {
                self.hex = add
            }
            
        }
    }
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        

       send_and_parse_json()
        
        get_json_data()
        
    }

    
    func get_json_data()
    {
        
        let url_to_request = "http://www.kaleidosblog.com/tutorial/colors.json"
        
        let url:NSURL = NSURL(string: url_to_request)!
        let session = NSURLSession.sharedSession()
        
        let request = NSMutableURLRequest(URL: url)
        request.HTTPMethod = "GET"
        request.cachePolicy = NSURLRequestCachePolicy.ReloadIgnoringCacheData
        request.timeoutInterval = 10
        
        
        let task = session.dataTaskWithRequest(request) {
            (
            let data, let response, let error) in
            
            guard let _:NSData = data, let _:NSURLResponse = response  where error == nil else {
                print("error")
                return
            }
            
            self.extract_json_data(data!)
            
        }
        
        task.resume()

    }
    
    func extract_json_data(data:NSData)
    {
        var json: AnyObject?

        
        do
        {
            json = try NSJSONSerialization.JSONObjectWithData(data, options: [])
        }
        catch
        {
            return
        }
        
        
        guard let data_dictionary = json as? NSDictionary else
        {
            return
        }
        
        
        guard let data_array = data_dictionary["colorsArray"] as? NSArray else
        {
            return
        }
        
        
        for(var i = 0; i < data_array.count; i++)
        {
            colors.append(Color(data: data_array[i] as! NSDictionary))
        }
        
        
        print(colors)

    }
    

    
    func send_and_parse_json()
    {
        var send_data:[String:String] = [String:String]()
        
        send_data["request"] = "kaleidosblog"
        send_data["some_extra_data"] = "1"
        
        do
        {
            let json = try NSJSONSerialization.dataWithJSONObject(send_data, options: NSJSONWritingOptions(rawValue: 0))
            let data_string = NSString(data: json, encoding:NSUTF8StringEncoding)
            
            data_request(data_string!)
            
        }
        catch
        {
            
        }
        
        
        

    }
    
    
    
    func data_request(data:NSString)
    {
        
        let url_to_request = "http://www.kaleidosblog.com/tutorial/get_data.php"
        
        let url:NSURL = NSURL(string: url_to_request)!
        let session = NSURLSession.sharedSession()
        
        let request = NSMutableURLRequest(URL: url)
        request.HTTPMethod = "POST"
        request.cachePolicy = NSURLRequestCachePolicy.ReloadIgnoringCacheData
        request.timeoutInterval = 10
        
        let paramString = "data=" + (data as String)
        request.HTTPBody = paramString.dataUsingEncoding(NSUTF8StringEncoding)
        
        let task = session.dataTaskWithRequest(request) {
            (
            let data, let response, let error) in
            
            guard let _:NSData = data, let _:NSURLResponse = response  where error == nil else {
                print("error")
                return
            }
            
            let dataString = NSString(data: data!, encoding: NSUTF8StringEncoding)
            
            print(dataString)
            
        }
        
        task.resume()
        
    }
    


}

