//
//  ViewController.swift
//  swift_error_handling


import UIKit

class ViewController: UIViewController {

    enum Error: ErrorType
    {
        case InvalidFormat
    }
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        error_test()
    }



    func error_test()
    {

        var result:CGFloat = 0
        
        do
        {
            result = try sum_it(5, n2: nil)
        }
        catch Error.InvalidFormat
        {
            print("error InvalidFormat")
        }
        catch
        {
            print("other error type")
        }

        

    }
    
    
    func sum_it(n1:CGFloat?, n2:CGFloat?) throws -> CGFloat
    {

        guard let _:CGFloat = n1, let _:CGFloat = n2 else
        {
            throw Error.InvalidFormat
        }

        return (n1! + n2!)
    }
}

