//
//  SideMenuController.swift
//  tutorial_side_menu
//

import UIKit

class SideMenuController: UIViewController,UITableViewDataSource, UITableViewDelegate {

    @IBOutlet var tableview: UITableView!
    var menu = Array<String>()
    var bcolor=UIColor(red:162/255.0,green:172/255.0,blue:180/255.0,alpha:1.0)
    
    override func viewDidLoad() {
        super.viewDidLoad()

        menu.append("View 1")
        menu.append("View 2")
        
        tableview.dataSource = self
        tableview.delegate = self
        tableview.backgroundColor = UIColor.clearColor()
        self.view.backgroundColor = bcolor
    }

    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int
    {
    return menu.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell
    {
        let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as UITableViewCell
        
        
        cell.textLabel?.text = menu[indexPath.row]
        cell.backgroundColor = UIColor.clearColor()
        
        var bgColorView = UIView()
        bgColorView.backgroundColor = UIColor.clearColor()
        cell.selectedBackgroundView = bgColorView
        
        return cell

    }
    

    
    func tableView(tableView: UITableView, didHighlightRowAtIndexPath indexPath: NSIndexPath)
    {
        let cell = tableview.cellForRowAtIndexPath(indexPath) as UITableViewCell!
        cell.backgroundColor=UIColor( red: 0, green: 0, blue:0.2, alpha: 0.1 )
    }
    func tableView(tableView: UITableView, didUnhighlightRowAtIndexPath indexPath: NSIndexPath)
    {
        let cell = tableview.cellForRowAtIndexPath(indexPath) as UITableViewCell!
        cell.backgroundColor=UIColor.clearColor()
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        sidemenuclick?.current_background = indexPath.row
        sidemenuclick?.request_background_update!()
    }
    

}
